class Respawnables_Mutator expands Mutator config(Respawnables);

var DeathMatchPlus MyGame;
var Respawnables_Link reLink;
var bool bNoLink;
var string Message;					//Info send to external database
var Respawnables_PRI Database[32];	//The temp database for each connected player, gets assigned once player has PRI.RespawnablesID
var bool bLog;						//True for debugging
var bool bUploadActivated;			//Used in function HandleEndGame() to begin upload sequence to external database in function Timer().
var bool bUploadComplete;			//True when last data has been sent to external database.
var int UploadArrayNum;				//Count of what PRI is currently beeing sent to external database

replication
{
	// Things the server should send to the client.
	reliable if (Role == ROLE_Authority)
		Database;
}

function AddToTempDatabase(PlayerPawn P)
{
local int i;
local string IP;

	for (i=0;i<32;i++)
		{
		if ( Database[i] == none )
			{
			if ( bLog )
				log("Respawnables: Player PRI assigned to temp database.");
			Database[i] = Respawnables_PRI(P.PlayerReplicationInfo);
			//Data syntax: ID:,RespawnablesID,Name,IP
			IP = P.GetPlayerNetworkAddress();
			IP = Left(IP, InStr(IP, ":"));
			reLink.SendAliveBeacon("ID:,"$Respawnables_PRI(P.PlayerReplicationInfo).RespawnablesID$","$P.PlayerReplicationInfo.PlayerName$","$IP$",");
			i = 999;
			}
		}
}

function Upload(int i)
{
local string Info;
//Upload syntax: UP:,RespawnablesID,Name,XP,Money,MaxSpree,WeaponString,InventoryString,

	Info = "UP:,"$Database[i].RespawnablesID$","$Database[i].PlayerName$","$Database[i].XP$","$Database[i].Money$","$Database[i].MaxSpree$","$Database[i].WeaponString$","$Database[i].InventoryString$",";
	reLink.SendAliveBeacon(Info);
	log("Respawnables: Uploading to external database("$i$"):"@Info);
}

function PreBeginPlay()
{
local Actor A;

	Super.PreBeginPlay();
	
	foreach AllActors(class'Actor',A)
		//If ( A.IsA('Pickup') || A.IsA('Weapon') )
		If ( A.IsA('Ammo') || A.IsA('Weapon') )
			A.Destroy();
			
	AddMutator(Level.Spawn(class'Respawnables_DamageMutator'));
	
	reLink = Spawn(class'Respawnables_Link');
	if ( reLink != None )
		{
		reLink.RM = Self;
		reLink.SendAliveBeacon("Hello!!");
		}
	else
		bNoLink = True;
}

function PostBeginPlay()
{
	MyGame = DeathMatchPlus(Level.Game);
	Super.PostBeginPlay();
	SetTimer(1.0,True);
}

function Timer()
{
local Pawn P;
local Respawnables_Pickup PU;

	//Try and link to database if prior attempt failed:
	if ( bNoLink )
		{
		reLink = Spawn(class'Respawnables_Link');
		if ( reLink != None )
			{
			reLink.RM = Self;
			reLink.SendAliveBeacon("Hello!!");
			bNoLink = False;
			}
		else
			bNoLink = True;
		}

	//Cycle pickups:
	ForEach AllActors(Class'Respawnables_Pickup',PU)
		{
		if ( PU.LifeTime <= 0 )
			{
			Spawn(class'UT_SpriteSmokePuff',,,PU.Location);
			PU.Destroy();
			}
		else
			PU.LifeTime -= 1;
		}

	//Cycle players:
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
			{
			if ( P.IsA('PlayerPawn') )
				{
				//Check if player is assigned to Temp database:
				if ( !Respawnables_PRI(PlayerPawn(P).PlayerReplicationInfo).bAddedToTempDB && Respawnables_PRI(PlayerPawn(P).PlayerReplicationInfo).RespawnablesID != "N/A" )
					{
					AddToTempDatabase(PlayerPawn(P));
					Respawnables_PRI(PlayerPawn(P).PlayerReplicationInfo).bAddedToTempDB = True;
					}
				//Check if player has Health Regrow
				if ( Respawnables_PRI(PlayerPawn(P).PlayerReplicationInfo).bHasHealthRegrow == True )
					{
					if ( P.Health < Respawnables_PRI(PlayerPawn(P).PlayerReplicationInfo).MaxHealth )
						P.Health++;
					}
				}
			else if ( P.IsA('Bot') )
				{
				//Check if Bot has no enemy:
				if ( Bot(P).Enemy == None )
					{
					FindEnemy(Bot(P));
					}
				//Try and make Bot fight more:
				if ( !Bot(P).IsInState('Dying') && Bot(P).Health > 0 )
					{
					if ( !Bot(P).IsInState('Attacking') )
						Bot(P).GotoState('Attacking');
					}
				}
			//Check if players weapon has ammo and regain it
			if ( P.Weapon != none && P.Weapon.AmmoType != none) 
				{
				if ( P.Weapon.AmmoType.AmmoAmount < P.Weapon.AmmoType.MaxAmmo )
					P.Weapon.AmmoType.AmmoAmount += 1;
				}
			}
	
	if ( bUploadActivated && !bUploadComplete )
		{
		Upload(UploadArrayNum);
		UploadArrayNum++;
		if ( UploadArrayNum >= 32 || Database[UploadArrayNum].PlayerName == "" )
			{
			bUploadComplete = True;
			}
		}
}

function bool HandleEndGame()
{
	if ( !bUploadActivated )
		{
		bUploadActivated = True;
		SetTimer(1.0,True);
		}
}

function FindEnemy(Bot B)
{
local Pawn P;
local Pawn NewEnemy;
local int HighestScore;

	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		{
		if ( P.PlayerReplicationInfo.Score >= HighestScore && P != B)
			{
			HighestScore = P.PlayerReplicationInfo.Score;
			NewEnemy = P;
			}
		}
	if ( NewEnemy != None )
		{
		B.Enemy = NewEnemy;
		}
}

function bool PreventDeath(Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
local Inventory Inv;
local Respawnables_Pickup Drop;
local float speed;
local int dice;
local bool bAlreadyGotBonus,bHasShield;

	if ( Killed.Inventory != none )
		{
		for (inv=Killed.Inventory; inv!=None; inv=inv.Inventory)
			{
			Killed.Inventory.Destroy();
			}
		}
		
	//Handle health pickup drops:
	if ( Killer != None && Killer.IsA('Pawn') && Killed != Killer )
		{
		//Spawn possible Health pickup:
		dice = Rand(100);
		if ( dice < 5 ) // chance in % of dropping health pickup
			{
			Drop = Spawn(Class'Respawnables_Pickup_Health',,,Killed.Location);
			if ( Drop != None )
				{
				speed = VSize(Killed.Velocity);
				Drop.RemoteRole = ROLE_DumbProxy;
				Drop.SetPhysics(PHYS_Falling);
				Drop.bCollideWorld = true;
				Drop.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 160);
				Drop.Fragger = Killer;
				bAlreadyGotBonus = True;
				}
			}
			
		//Spawn possible Tornado pickup:
		dice = Rand(100);
		if ( dice < 3 && !bAlreadyGotBonus && Killer.GroundSpeed == Killer.Default.GroundSpeed ) // chance in % of dropping tornado pickup
			{
			Drop = Spawn(Class'Respawnables_Pickup_Tornado',,,Killed.Location);
			if ( Drop != None )
				{
				speed = VSize(Killed.Velocity);
				Drop.RemoteRole = ROLE_DumbProxy;
				Drop.SetPhysics(PHYS_Falling);
				Drop.bCollideWorld = true;
				Drop.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 160);
				Drop.Fragger = Killer;
				bAlreadyGotBonus = True;
				}
			}
			
		//Spawn possible Shield pickup:
		dice = Rand(100);
		if ( dice < 3 && !bAlreadyGotBonus && Killer.IsA('PlayerPawn') && !Respawnables_PRI(PlayerPawn(Killer).PlayerReplicationInfo).bHasShield ) // chance in % of dropping shield pickup
			{
			Drop = Spawn(Class'Respawnables_Pickup_Shield',,,Killed.Location);
			if ( Drop != None )
				{
				speed = VSize(Killed.Velocity);
				Drop.RemoteRole = ROLE_DumbProxy;
				Drop.SetPhysics(PHYS_Falling);
				Drop.bCollideWorld = true;
				Drop.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 160);
				Drop.Fragger = Killer;
				bAlreadyGotBonus = True;
				}
			}
		
		//Spawn possible Double Damage pickup:
		dice = Rand(100);
		if ( dice < 3 && !bAlreadyGotBonus && Killer.IsA('PlayerPawn') && !Respawnables_PRI(PlayerPawn(Killer).PlayerReplicationInfo).bHasDoubleDamage ) // chance in % of dropping double damage pickup
			{
			Drop = Spawn(Class'Respawnables_Pickup_DoubleDamage',,,Killed.Location);
			if ( Drop != None )
				{
				speed = VSize(Killed.Velocity);
				Drop.RemoteRole = ROLE_DumbProxy;
				Drop.SetPhysics(PHYS_Falling);
				Drop.bCollideWorld = true;
				Drop.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 160);
				Drop.Fragger = Killer;
				bAlreadyGotBonus = True;
				}
			}
		
		//Spawn possible Health Regrow pickup:
		dice = Rand(100);
		if ( dice < 3 && !bAlreadyGotBonus && Killer.IsA('PlayerPawn') && !Respawnables_PRI(PlayerPawn(Killer).PlayerReplicationInfo).bHasHealthRegrow ) // chance in % of dropping health regrow pickup
			{
			Drop = Spawn(Class'Respawnables_Pickup_HealthRegrow',,,Killed.Location);
			if ( Drop != None )
				{
				speed = VSize(Killed.Velocity);
				Drop.RemoteRole = ROLE_DumbProxy;
				Drop.SetPhysics(PHYS_Falling);
				Drop.bCollideWorld = true;
				Drop.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 160);
				Drop.Fragger = Killer;
				bAlreadyGotBonus = True;
				}
			}
			
		//Calculate what frag pickup to drop:
		if ( !Killer.IsA('Bot') && Killed.IsA('Bot') )
			{
			Drop = Spawn(Class'Respawnables_Pickup',,,Killed.Location);
			Respawnables_PRI(Killer.PlayerReplicationInfo).XP += 1;
			}
		else if ( !Killer.IsA('Bot') && Killed.IsA('PlayerPawn') )
			{
			//check if killed has less or same XP than killer
			if ( Respawnables_PRI(Killed.PlayerReplicationInfo).XP <= Respawnables_PRI(Killer.PlayerReplicationInfo).XP )
				{
				Drop = Spawn(Class'Respawnables_Pickup',,,Killed.Location);
				if ( Killer.IsA('PlayerPawn') )
					Respawnables_PRI(Killer.PlayerReplicationInfo).XP += 1;
				}
			//else check if killed has 3x more XP than killer
			else if ( Respawnables_PRI(Killed.PlayerReplicationInfo).XP * 3 > Respawnables_PRI(Killer.PlayerReplicationInfo).XP )
				{
				Drop = Spawn(Class'Respawnables_Pickup_Frag30',,,Killed.Location);
				if ( Killer.IsA('PlayerPawn') )
					Respawnables_PRI(Killer.PlayerReplicationInfo).XP += 5;
				}
			//else check if killed has 2x more XP than killer
			else if ( Respawnables_PRI(Killed.PlayerReplicationInfo).XP * 2 > Respawnables_PRI(Killer.PlayerReplicationInfo).XP )
				{
				Drop = Spawn(Class'Respawnables_Pickup_Frag20',,,Killed.Location);
				if ( Killer.IsA('PlayerPawn') )
					Respawnables_PRI(Killer.PlayerReplicationInfo).XP += 3;
				}
			//else check if killed has more XP than killer
			else if ( Respawnables_PRI(Killed.PlayerReplicationInfo).XP > Respawnables_PRI(Killer.PlayerReplicationInfo).XP )
				{
				Drop = Spawn(Class'Respawnables_Pickup_Frag15',,,Killed.Location);
				if ( Killer.IsA('PlayerPawn') )
					Respawnables_PRI(Killer.PlayerReplicationInfo).XP += 2;
				}
			}
		if ( Drop != None )
			{
			speed = VSize(Killed.Velocity);
			Drop.RemoteRole = ROLE_DumbProxy;
			Drop.SetPhysics(PHYS_Falling);
			Drop.bCollideWorld = true;
			Drop.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 320);
			Drop.Fragger = Killer;
			}
		}
		
	//Handle Killed Frag spree:
	if ( Killed.IsA('PlayerPawn') )
		{
		Respawnables_PRI(PlayerPawn(Killed).PlayerReplicationInfo).NumFragged = 0;
		}

	//Handle Killer Frag spree:
	if ( Killer.IsA('PlayerPawn') && Killed != Killer )
		{
		Respawnables_PRI(PlayerPawn(Killer).PlayerReplicationInfo).NumFragged += 1;
		if ( Respawnables_PRI(PlayerPawn(Killer).PlayerReplicationInfo).NumFragged > Respawnables_PRI(PlayerPawn(Killer).PlayerReplicationInfo).MaxSpree )
			{
			Respawnables_PRI(PlayerPawn(Killer).PlayerReplicationInfo).MaxSpree = Respawnables_PRI(PlayerPawn(Killer).PlayerReplicationInfo).NumFragged;
			Killer.ReceiveLocalizedMessage( class'Respawnables_MessageNewMaxSpree',, );
			}
		}
			
	if ( NextMutator != None )
		{
		NextMutator.PreventDeath(Killer, Killed, damageType, HitLocation);
		}
}

function ModifyPlayer(Pawn Other)
{
local Inventory Inv;

	if ( Other.IsA('PlayerPawn') )
		{
		Respawnables(Level.Game).GiveWeapon(Other,"Respawnables.Respawnables_Weapon_Enforcer");	//Base weapon
		Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).bHasTornado = False;
		Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).bHasShield = False;
		Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).bHasHealthRegrow = False;
		PlayerPawn(Other).SetDefaultDisplayProperties();
		Other.AirControl = Other.default.AirControl;
		Other.JumpZ = Other.default.JumpZ * 1.1;
		Other.GroundSpeed = Other.default.GroundSpeed;
		Other.WaterSpeed = Other.default.WaterSpeed;
		Other.AirSpeed = Other.default.AirSpeed;
		Other.Acceleration = Other.default.Acceleration;
		//Assign player weapons:
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).WeaponString, "!UZ") != -1 )
			Respawnables(Level.Game).GiveWeapon(Other,"Respawnables.Respawnables_Weapon_UZI");
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).WeaponString, "!BR") != -1 )
			Respawnables(Level.Game).GiveWeapon(Other,"Respawnables.Respawnables_Weapon_BioRifle");
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).WeaponString, "!RL") != -1 )
			Respawnables(Level.Game).GiveWeapon(Other,"Respawnables.Respawnables_Weapon_RocketLauncher");
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).WeaponString, "!FC") != -1 )
			Respawnables(Level.Game).GiveWeapon(Other,"Respawnables.Respawnables_Weapon_FlakCannon");
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).WeaponString, "!MG") != -1 )
			Respawnables(Level.Game).GiveWeapon(Other,"Respawnables.Respawnables_Weapon_Minigun");
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).WeaponString, "!PG") != -1 )
			Respawnables(Level.Game).GiveWeapon(Other,"Respawnables.Respawnables_Weapon_PulseGun");
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).WeaponString, "!RJ") != -1 )
			Respawnables(Level.Game).GiveWeapon(Other,"Respawnables.Respawnables_Weapon_RazorJack");
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).WeaponString, "!SR") != -1 )
			Respawnables(Level.Game).GiveWeapon(Other,"Respawnables.Respawnables_Weapon_ShockRifle");
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).WeaponString, "!SN") != -1 )
			Respawnables(Level.Game).GiveWeapon(Other,"Respawnables.Respawnables_Weapon_SniperRifle");
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).WeaponString, "!DP") != -1 )
			Respawnables(Level.Game).GiveWeapon(Other,"Respawnables.Respawnables_Weapon_DispersionPistol");
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).WeaponString, "!CS") != -1 )
			Respawnables(Level.Game).GiveWeapon(Other,"Respawnables.Respawnables_Weapon_ChainSaw");
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).WeaponString, "!ST") != -1 )
			Respawnables(Level.Game).GiveWeapon(Other,"Respawnables.Respawnables_Weapon_Stinger");
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).WeaponString, "!TL") != -1 )
			Respawnables(Level.Game).GiveWeapon(Other,"Respawnables.Respawnables_Weapon_Translocator");
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).WeaponString, "!GH") != -1 )
			Respawnables(Level.Game).GiveWeapon(Other,"Respawnables.Respawnables_Weapon_GrapplingHook");
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).WeaponString, "!DE") != -1 )
			{
			Inv = Spawn( class'Respawnables_Weapon_Enforcer' );
			if ( Respawnables_Weapon_Enforcer(Inv) != None )
				{
				Other.Inventory.HandlePickupQuery(Inv);
				}
			Inv.Destroy();
			}
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).WeaponString, "!BZ") != -1 )
			Respawnables(Level.Game).GiveWeapon(Other,"Respawnables.Respawnables_Weapon_Bazooka");
		//Assign gear:
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).InventoryString, "!RA") != -1 )
			{
			if ( !Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).bRadarMutatedOff )
				Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).bHasRadar = True;
			}
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).InventoryString, "!JB") != -1 )
			{
			Inv = Spawn( class'Respawnables_Gear_JumpBoots' );
			if ( Respawnables_Gear_JumpBoots(Inv) != None )
				{
				Inv.bHeldItem = True;
				Inv.RespawnTime = 0.0;
				Inv.GiveTo(Other);
				Inv.Activate();
				Other.JumpZ = Other.Default.JumpZ * 3;
				}
			}
		//Assign mental:
		Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).MaxHealth = 100;
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).InventoryString, "!SH") != -1 )
			{
			Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).MaxHealth += 10;
			}
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).InventoryString, "!MH") != -1 )
			{
			Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).MaxHealth += 25;
			}
		if ( InStr(Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).InventoryString, "!LH") != -1 )
			{
			Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).MaxHealth += 50;
			}
		Other.Health = Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).MaxHealth;
		}
	else if ( Other.IsA('Bot') )
		{
		Other.AirControl = Other.default.AirControl;
		Other.JumpZ = Other.default.JumpZ * 1.1;
		Other.GroundSpeed = Other.default.GroundSpeed;
		Other.WaterSpeed = Other.default.WaterSpeed;
		Other.AirSpeed = Other.default.AirSpeed;
		Other.Acceleration = Other.default.Acceleration;
		//Add check for custom bots here later to assign them their own weapon:
		Respawnables(Level.Game).GiveWeapon(Other,"Respawnables.Respawnables_Weapon_Enforcer");	//Temp weapon until custom bots are added
		}
	
	
	if ( NextMutator != None )
		NextMutator.ModifyPlayer(Other);
}

function bool AlwaysKeep(Actor Other)
{
	if ( Other.IsA('StationaryPawn') )
		return true;

	if (Other.IsA('PlayerPawn'))
        {
		PlayerPawn(Other).PlayerReplicationInfoClass = class'Respawnables_PRI';
		return true;
		}	
		
	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );
	return false;
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
local Inventory Inv;

	bSuperRelevant = 1;

	if ( Other.IsA('StationaryPawn') )
		return true;

	Inv = Inventory(Other);
 	if ( Inv == None )
		{
		bSuperRelevant = 0;
		if ( Other.IsA('TorchFlame') )
			Other.NetUpdateFrequency = 0.5;
		return true;
		}

	if ( Other.IsA('Pickup') )
		{
		Pickup(Other).bAutoActivate = true;
		if ( Other.IsA('TournamentPickup') )
			return true;
		}
	
	bSuperRelevant = 0;
	return true;
}

function Mutate(string MutateString, PlayerPawn Sender)
{
local Respawnables_PRI PRI;
local Inventory Inv;
local bool bFlashlight;

	//Check if player wants to shop:
	if ( Left(Caps(MutateString),12) == "SELECTPLAYER" )
		{
		PRI = Respawnables_PRI(Sender.PlayerReplicationInfo);
		//Player pressed ENTER, now do some stuff here:
		if ( PRI.Category == "Game" )
			{
			//Player chose to begin game, so close menu and start game for player:
			PRI.bStarted = True;
			}
		else if ( PRI.Category == "Weapons" )
			{
			//Player chose to purchase a weapon, now see what weapon and if he already has it or can afford it:
			//GES Bio Rifle:
			if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 0 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).WeaponString, "!BR") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 1000 )
						{
						PurchaseWeapon(Sender, 1000,"!BR","Respawnables.Respawnables_Weapon_BioRifle");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			//Rocket Launcher:
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 1 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).WeaponString, "!RL") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 5000 )
						{
						PurchaseWeapon(Sender, 5000,"!RL","Respawnables.Respawnables_Weapon_RocketLauncher");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			//Flak Cannon:
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 2 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).WeaponString, "!FC") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 7500 )
						{
						PurchaseWeapon(Sender, 7500,"!FC","Respawnables.Respawnables_Weapon_FlakCannon");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			//Minigun:
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 3 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).WeaponString, "!MG") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 4000 )
						{
						PurchaseWeapon(Sender, 4000,"!MG","Respawnables.Respawnables_Weapon_Minigun");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			//Pulse Gun:
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 4 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).WeaponString, "!PG") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 3500 )
						{
						PurchaseWeapon(Sender, 3500,"!PG","Respawnables.Respawnables_Weapon_PulseGun");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			//Razor Jack:
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 5 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).WeaponString, "!RJ") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 3000 )
						{
						PurchaseWeapon(Sender, 3000,"!RJ","Respawnables.Respawnables_Weapon_RazorJack");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			//ASMD Shock Rifle:
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 6 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).WeaponString, "!SR") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 5000 )
						{
						PurchaseWeapon(Sender, 5000,"!SR","Respawnables.Respawnables_Weapon_ShockRifle");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			//Sniper Rifle:
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 7 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).WeaponString, "!SN") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 5000 )
						{
						PurchaseWeapon(Sender, 5000,"!SN","Respawnables.Respawnables_Weapon_SniperRifle");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			//DispersionPistol:
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 8 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).WeaponString, "!DP") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 500 )
						{
						PurchaseWeapon(Sender, 500,"!DP","Respawnables.Respawnables_Weapon_DispersionPistol");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			//Chainsaw:
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 9 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).WeaponString, "!CS") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 500 )
						{
						PurchaseWeapon(Sender, 500,"!CS","Respawnables.Respawnables_Weapon_ChainSaw");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			//Stinger:
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 10 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).WeaponString, "!ST") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 3000 )
						{
						PurchaseWeapon(Sender, 3000,"!ST","Respawnables.Respawnables_Weapon_Stinger");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			//Translocator Device:
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 11 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).WeaponString, "!TL") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 10000 )
						{
						PurchaseWeapon(Sender, 10000,"!TL","Respawnables.Respawnables_Weapon_Translocator");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			//Grappling Hook:
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 12 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).WeaponString, "!GH") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 10000 )
						{
						PurchaseWeapon(Sender, 10000,"!GH","Respawnables.Respawnables_Weapon_GrapplingHook");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			//UZI:
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 13 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).WeaponString, "!UZ") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 25000 )
						{
						PurchaseWeapon(Sender, 25000,"!UZ","Respawnables.Respawnables_Weapon_UZI");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			//Double Enforcers:
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 14 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).WeaponString, "!DE") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 1500 )
						{
						PurchaseWeapon(Sender, 1500,"!DE","Respawnables.Respawnables_Weapon_Enforcer");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			//Bazooka:
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 15 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).WeaponString, "!BZ") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 17500 )
						{
						PurchaseWeapon(Sender, 17500,"!BZ","Respawnables.Respawnables_Weapon_Bazooka");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			}
		else if ( PRI.Category == "Gear" )
			{
			//Player chose to purchase a gear item, now see what item and if he already has it or can afford it:
			//Radar:
			if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 0 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).InventoryString, "!RA") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 10000 )
						{
						PurchaseGear(Sender, 10000,"!RA","Radar");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 1 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).InventoryString, "!FL") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 500 )
						{
						PurchaseGear(Sender, 500,"!FL","Flashlight");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 2 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).InventoryString, "!BA") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 5000 )
						{
						PurchaseGear(Sender, 5000,"!BA","BodyArmor");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 3 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).InventoryString, "!JB") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 500 )
						{
						PurchaseGear(Sender, 500,"!JB","JumpBoots");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 4 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).InventoryString, "!SB") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 10000 )
						{
						PurchaseGear(Sender, 10000,"!SB","ShieldBelt");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 5 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).InventoryString, "!TP") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 2000 )
						{
						PurchaseGear(Sender, 2000,"!TP","ThighPads");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			}
		else if ( PRI.Category == "Mental" )
			{
			//Player chose to purchase a mental item, now see what item and if he already has it or can afford it:
			//Radar:
			if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 0 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).InventoryString, "!RD") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 10000 )
						{
						PurchaseMental(Sender, 10000,"!RD","ReducedDamage");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			//small health upgrade:
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 1 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).InventoryString, "!SH") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 1000 )
						{
						PurchaseMental(Sender, 1000,"!SH","Small Health Upgrade");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			//medium health upgrade:
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 2 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).InventoryString, "!MH") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 2500 )
						{
						PurchaseMental(Sender, 2500,"!MH","Medium Health Upgrade");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			//large health upgrade:
			else if ( Respawnables_PRI(Sender.PlayerReplicationInfo).NumInCategory == 3 )
				{
				if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).InventoryString, "!LH") != -1 )
					{
					//player already has this weapon so do nothing :-)
					}
				else
					{
					if ( Respawnables_PRI(Sender.PlayerReplicationInfo).Money >= 5000 )
						{
						PurchaseMental(Sender, 5000,"!LH","Large Health Upgrade");
						}
					else
						{
						//Player can't afford weapon so do nothing :-)
						}
					}
				}
			}
		}
	else if ( Left(Caps(MutateString),5) == "RADAR" )
		{
		if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).InventoryString, "!RA") != -1 )
			{
			if ( Respawnables_PRI(Sender.PlayerReplicationInfo).bHasRadar )
				{
				Respawnables_PRI(Sender.PlayerReplicationInfo).bHasRadar = False;
				Respawnables_PRI(Sender.PlayerReplicationInfo).bRadarMutatedOff = True;
				Sender.ReceiveLocalizedMessage( class'Respawnables_MessageRadar',0, );
				}
			else
				{
				Respawnables_PRI(Sender.PlayerReplicationInfo).bHasRadar = True;
				Respawnables_PRI(Sender.PlayerReplicationInfo).bRadarMutatedOff = False;
				Sender.ReceiveLocalizedMessage( class'Respawnables_MessageRadar',1, );
				}
			}
		}
	else if ( Left(Caps(MutateString),4) == "JUMP" )
		{
		if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).InventoryString, "!JB") != -1 )
			{
			if ( Respawnables_PRI(Sender.PlayerReplicationInfo).bJumpBoots )
				{
				Respawnables_PRI(Sender.PlayerReplicationInfo).bJumpBoots = False;
				Sender.JumpZ = Sender.Default.JumpZ * 1.1;
				Sender.ReceiveLocalizedMessage( class'Respawnables_MessageBoots',0, );
				}
			else
				{
				Respawnables_PRI(Sender.PlayerReplicationInfo).bJumpBoots = True;
				Sender.JumpZ = Sender.Default.JumpZ * 3;
				Sender.ReceiveLocalizedMessage( class'Respawnables_MessageBoots',1, );
				}
			}
		}
	else if ( Left(Caps(MutateString),5) == "LIGHT" )
		{
		if ( InStr(Respawnables_PRI(Sender.PlayerReplicationInfo).InventoryString, "!FL") != -1 )
			{
			for ( Inv=Sender.inventory; Inv!=None; Inv=Inv.inventory )
				{
				if ( Inv.IsA('Respawnables_Pickup_Flashlight') )
					{
					//lights off:
					Respawnables_Pickup_Flashlight(Inv).s.Destroy();
					Respawnables_Pickup_Flashlight(Inv).Owner.PlaySound(Inv.DeActivateSound);
					if ( !bFlashlight )
						Pawn(Respawnables_Pickup_Flashlight(Inv).Owner).ClientMessage(Respawnables_Pickup_Flashlight(Inv).ExpireMessage);
					Inv.Destroy();
					bFlashlight = True;
					}
				}
			if ( !bFlashlight )
				{
				Inv = Spawn( class'Respawnables_Pickup_Flashlight' );
				if ( Inv != None )
					{
					Inv.Charge = 99999;
					Inv.RespawnTime=0;
					Inv.GiveTo(Sender);
					Inv.Activate();
					}
				}
			}
		}
}

function PurchaseWeapon(PlayerPawn P,int Price,string Alias,string Weapon)
{
local inventory Inv;
	
	Respawnables_PRI(P.PlayerReplicationInfo).WeaponString = Respawnables_PRI(P.PlayerReplicationInfo).WeaponString$Alias;
	Respawnables_PRI(P.PlayerReplicationInfo).Money -= Price;
	if ( Alias == "!DE" )
		{
		Inv = Spawn( class'Respawnables_Weapon_Enforcer' );
			if ( Respawnables_Weapon_Enforcer(Inv) != None )
				{
				P.Inventory.HandlePickupQuery(Inv);
				}
			Inv.Destroy();
		}
	else
		{
		Respawnables(Level.Game).GiveWeapon(P,Weapon);
		}
	P.ClientPlaySound(Sound'BuySound', , true);
}

function PurchaseGear(PlayerPawn P,int Price,string Alias,string Gear)
{
local inventory Inv;
	
	Respawnables_PRI(P.PlayerReplicationInfo).InventoryString = Respawnables_PRI(P.PlayerReplicationInfo).InventoryString$Alias;
	Respawnables_PRI(P.PlayerReplicationInfo).Money -= Price;
	if ( Alias == "!RA" )
		{
		Respawnables_PRI(P.PlayerReplicationInfo).bHasRadar = True;
		}
	else if ( Alias == "!JB" )
		{
		Inv = Spawn( class'Respawnables_Gear_JumpBoots' );
			if ( Respawnables_Gear_JumpBoots(Inv) != None )
				{
				Inv.bHeldItem = True;
				Inv.RespawnTime = 0.0;
				Inv.GiveTo(P);
				Inv.Activate();
				P.JumpZ = P.Default.JumpZ * 3;
				}
		}
	else if ( Alias == "!BA" )
		{
		Inv = Spawn( class'Armor2' );
			if ( Inv != None )
				{
				Inv.Charge = 75;
				Inv.bIsAnArmor = True;
				Inv.RespawnTime=0;
				Inv.GiveTo(P);
				}
		}
	else if ( Alias == "!TP" )
		{
		Inv = Spawn( class'ThighPads' );
			if ( Inv != None )
				{
				Inv.Charge = 25;
				Inv.bIsAnArmor = True;
				Inv.RespawnTime=0;
				Inv.GiveTo(P);
				}
		}
	else if ( Alias == "!SB" )
		{
		Inv = Spawn( class'Respawnables_Pickup_ShieldBelt' );
			if ( Inv != None )
				{
				Inv.Charge = 100;
				Inv.bIsAnArmor = True;
				Inv.RespawnTime=0;
				Inv.GiveTo(P);
				}
		}
	else if ( Alias == "!FL" )
		{
		Inv = Spawn( class'Respawnables_Pickup_Flashlight' );
			if ( Inv != None )
				{
				Inv.Charge = 99999;
				Inv.RespawnTime=0;
				Inv.GiveTo(P);
				Inv.Activate();
				}
		}

	P.ClientPlaySound(Sound'BuySound', , true);
}

function PurchaseMental(PlayerPawn P,int Price,string Alias,string Mental)
{
local inventory Inv;
	
	Respawnables_PRI(P.PlayerReplicationInfo).InventoryString = Respawnables_PRI(P.PlayerReplicationInfo).InventoryString$Alias;
	Respawnables_PRI(P.PlayerReplicationInfo).Money -= Price;
	P.ClientPlaySound(Sound'BuySound', , true);
	if ( Alias == "!SH" )
		Respawnables_PRI(P.PlayerReplicationInfo).MaxHealth += 10;
	else if ( Alias == "!MH" )
		Respawnables_PRI(P.PlayerReplicationInfo).MaxHealth += 25;
	else if ( Alias == "!LH" )
		Respawnables_PRI(P.PlayerReplicationInfo).MaxHealth += 50;
}

function PingRecieved()
{
	log("Respawnables: Linkactors ping was recieved by database server.");
}

function IDRecieved(String Data)
{
local int i,length;
local string XP,Money,MaxSpree,WString,IString;

	log("Respawnables: Players ID was recieved by database server.");
	log("Respawnables: Data recieved:"@Data);
	for (i=0;i<32;i++)
		{
		if ( InStr(Data, Database[i].RespawnablesID ) != -1 )
			{
			if ( InStr(Data, "#Newbie#" ) != -1 )
				Database[i].bStarted = True;
			else
				{
				//Assign external database values to temp mutator database:
				//player data syntax: ##RespawnablesID,XP,Money,MaxSpree,WeaponString,InventoryString,
				Data = Mid(Data, InStr(Data, ","));
				length = len(Data) - 1;
				Data = right(Data,length);
				log("Respawnables: Data="@Data);
				
				XP = Left(Data, InStr(Data, ","));
				Database[i].XP = int(XP);
				log("Respawnables: XP="@XP);
				
				Data = Mid(Data, InStr(Data, ","));
				length = len(Data) - 1;
				Data = right(Data,length);
				log("Respawnables: Data="@Data);
				
				Money = Left(Data, InStr(Data, ","));
				Database[i].Money = int(Money);
				log("Respawnables: Money="@Money);
				
				Data = Mid(Data, InStr(Data, ","));
				length = len(Data) - 1;
				Data = right(Data,length);
				log("Respawnables: Data="@Data);
				
				MaxSpree = Left(Data, InStr(Data, ","));
				Database[i].MaxSpree = int(MaxSpree);
				log("Respawnables: MaxSpree="@MaxSpree);
				
				Data = Mid(Data, InStr(Data, ","));
				length = len(Data) - 1;
				Data = right(Data,length);
				log("Respawnables: Data="@Data);
				
				WString = Left(Data, InStr(Data, ","));
				Database[i].WeaponString = WString;
				log("Respawnables: WString="@WString);
				
				Data = Mid(Data, InStr(Data, ","));
				length = len(Data) - 1;
				Data = right(Data,length);
				log("Respawnables: Data="@Data);
				
				IString = Left(Data, InStr(Data, ","));
				Database[i].InventoryString = IString;
				log("Respawnables: IString="@IString);
				
				//Database[i].bStarted = True;	//!!!!Temp for testing, needs removed once upload script is tested!!!!!
				Database[i].bSynced = True;
				}
			i = 999;
			}
		}
}

defaultproperties
{
bUploadActivated=False
bUploadComplete=False
UploadArrayNum=0
Message="Hello!!"
}
